(function($) {

  'use strict';

  //This object is used to save all the variable states of the menu
  window.DALT.states = {

    dalt_hot: false,
    synthetic_clipboard: null,
    cell_properties_message_timeout_handler: null,
    table_message_timeout_handler: null,
    tableToDelete: null,
    copiedCellProperties: {
      data: null,
      source: null
    },

  };

  bindEventListeners();

  /**
   * Bind the event listeners.
   */
  function bindEventListeners() {

    'use strict';

    $(document).ready(function() {

      'use strict';

      window.DALT.utility.initialize_handsontable();
      window.DALT.utility.initialize_chosen();
      window.DALT.utility.remove_border_last_element_daext_form_table();
      window.DALT.utility.responsive_sidebar_container();
      window.DALT.utility.disable_specific_keyboard_shortcuts();
      window.DALT.utility.refresh_cell_properties_highlight();

      $(document.body).on('click', '#save' , function(){

        'use strict';

        const reload_menu = parseInt($(this).data('reload-menu'), 10) == 1 ? true : false;
        const validation_result = window.DALT.utility.save_table(reload_menu);

        //show error message
        if (validation_result === true) {

          if (reload_menu === false) {

            //hide error message
            $('#table-error p').html('');
            $('#table-error').hide();

            //display temporary success message
            $('#table-success p').text(objectL10n.table_success);
            $('#table-success').show();
            clearTimeout(window.DALT.states.table_message_timeout_handler);
            window.DALT.states.table_message_timeout_handler = setTimeout(
                function() {

                  'use strict';

                  $('#table-success').hide();

                },
                3000);

          }

        } else {

          //display error message
          $('#table-error p').
              html(objectL10n.table_error_partial_message + ' <strong>' + validation_result.join(', ') + '</strong>');
          $('#table-error').show();

        }

      });

      $(document.body).on('click', '#close' , function(){

        'use strict';

        //reload the dashboard menu
        window.location.replace(DALT_PARAMETERS.admin_url + 'admin.php?page=dalt-tables');

      });

      $('#rows').change(function() {

        'use strict';

        window.DALT.utility.update_rows();

      });

      $('#columns').change(function() {

        'use strict';

        window.DALT.utility.update_columns();
        window.DALT.utility.update_order_by();

      });

      $(document.body).on('click', '.update-reset-cell-properties' , function(){

        'use strict';

        const element_id = $(this).attr('id');

        window.DALT.utility.update_reset_cell_properties(element_id);

      });

      $(document.body).on('click', '.group-trigger' , function(){

        'use strict';

        //open and close the various sections of the tables area
        const target = $(this).attr('data-trigger-target');
        $('.' + target).toggle();
        $(this).find('.expand-icon').toggleClass('arrow-down');

        window.DALT.utility.remove_border_last_element_daext_form_table();

      });

      jQuery(window).resize(function() {

        'use strict';

        window.DALT.utility.responsive_sidebar_container();

      });

      $(function() {

        'use strict';

        $('.dialog-alert').dialog({
          autoOpen: false,
          resizable: false,
          height: 'auto',
          width: 340,
          modal: true,
          buttons: [
            {
              tabIndex: -1,
              text: 'Close',
              click: function() {

                'use strict';

                $(this).dialog('close');

              },
            },
          ],
        });
      });

      //Dialog Confirm ---------------------------------------------------------------------------------------------------
      $(function() {

        'use strict';

        $('#dialog-confirm').dialog({
          autoOpen: false,
          resizable: false,
          height: 'auto',
          width: 340,
          modal: true,
          buttons: {
            [objectL10n.delete]: function() {

              'use strict';

              $('#form-delete-' + window.DALT.states.tableToDelete).submit();

            },
            [objectL10n.cancel]: function() {

              'use strict';

              $(this).dialog('close');

            },
          },
        });

      });

      //Click event handler on the delete button
      $(document.body).on('click', '.menu-icon.delete' , function(){

        'use strict';

        event.preventDefault();
        window.DALT.states.tableToDelete = $(this).prev().val();
        $('#dialog-confirm').dialog('open');

      });

    });

  }

}(window.jQuery));